/**
* \file: AudioFormat.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include "IAudioOutAdapter.h"

namespace adit { namespace carplay
{

AudioFormatStruct::AudioFormatStruct()
{
    SampleRate = 0;
    BitsPerChannel = 0;
    Channels = 2;
}

AudioFormatStruct::AudioFormatStruct(AudioFormat format)
{
    AudioFormatStruct result;
    switch (format)
    {
    case AudioFormat_8KHz_16Bit_Mono:
        SampleRate = 8000; BitsPerChannel = 16; Channels = 1;
        break;
    case AudioFormat_8KHz_16Bit_Stereo:
        SampleRate = 8000; BitsPerChannel = 16; Channels = 2;
        break;
    case AudioFormat_16KHz_16Bit_Mono:
        SampleRate = 16000; BitsPerChannel = 16; Channels = 1;
        break;
    case AudioFormat_16KHz_16Bit_Stereo:
        SampleRate = 16000; BitsPerChannel = 16; Channels = 2;
        break;
    case AudioFormat_24KHz_16Bit_Mono:
        SampleRate = 24000; BitsPerChannel = 16; Channels = 1;
        break;
    case AudioFormat_24KHz_16Bit_Stereo:
        SampleRate = 24000; BitsPerChannel = 16; Channels = 2;
        break;
    case AudioFormat_32KHz_16Bit_Mono:
        SampleRate = 32000; BitsPerChannel = 16; Channels = 1;
        break;
    case AudioFormat_32KHz_16Bit_Stereo:
        SampleRate = 32000; BitsPerChannel = 16; Channels = 2;
        break;
    case AudioFormat_44KHz_16Bit_Mono:
        SampleRate = 44000; BitsPerChannel = 16; Channels = 1;
        break;
    case AudioFormat_44KHz_16Bit_Stereo:
        SampleRate = 44000; BitsPerChannel = 16; Channels = 2;
        break;
    case AudioFormat_44KHz_24Bit_Mono:
        SampleRate = 44000; BitsPerChannel = 24; Channels = 1;
        break;
    case AudioFormat_44KHz_24Bit_Stereo:
        SampleRate = 44000; BitsPerChannel = 24; Channels = 2;
        break;
    case AudioFormat_48KHz_16Bit_Mono:
        SampleRate = 48000; BitsPerChannel = 16; Channels = 1;
        break;
    case AudioFormat_48KHz_16Bit_Stereo:
        SampleRate = 48000; BitsPerChannel = 16; Channels = 2;
        break;
    case AudioFormat_48KHz_24Bit_Mono:
        SampleRate = 48000; BitsPerChannel = 24; Channels = 1;
        break;
    case AudioFormat_48KHz_24Bit_Stereo:
        SampleRate = 48000; BitsPerChannel = 24; Channels = 2;
        break;
    default:
        SampleRate = 0;
        BitsPerChannel = 0;
        Channels = 0;
        break;
    }
}

AudioFormat AudioFormatStructToEnum(AudioFormatStruct format)
{
    AudioFormat result;
    uint32_t* tmp = reinterpret_cast<uint32_t*>(&format);
    switch (*tmp)
    {
    case 0x1f401001:
        result = AudioFormat_8KHz_16Bit_Mono;
        break;
    case 0x1f401002:
        result = AudioFormat_8KHz_16Bit_Stereo;
        break;
    case 0x3e801001:
        result = AudioFormat_16KHz_16Bit_Mono;
        break;
    case 0x3e801002:
        result = AudioFormat_16KHz_16Bit_Stereo;
        break;
    case 0x5dc01001:
        result = AudioFormat_24KHz_16Bit_Mono;
        break;
    case 0x5dc01002:
        result = AudioFormat_24KHz_16Bit_Stereo;
        break;
    case 0x7d001001:
        result = AudioFormat_32KHz_16Bit_Mono;
        break;
    case 0x7d001002:
        result = AudioFormat_32KHz_16Bit_Stereo;
        break;
    case 0xabe01001:
        result = AudioFormat_44KHz_16Bit_Mono;
        break;
    case 0xabe01002:
        result = AudioFormat_44KHz_16Bit_Stereo;
        break;
    case 0xabe01801:
        result = AudioFormat_44KHz_24Bit_Mono;
        break;
    case 0xabe01802:
        result = AudioFormat_44KHz_24Bit_Stereo;
        break;
    case 0xbb801001:
        result = AudioFormat_48KHz_16Bit_Mono;
        break;
    case 0xbb801002:
        result = AudioFormat_48KHz_16Bit_Stereo;
        break;
    case 0xbb801801:
        result = AudioFormat_48KHz_24Bit_Mono;
        break;
    case 0xbb801802:
        result = AudioFormat_48KHz_24Bit_Stereo;
        break;
    default:
        result = AudioFormat_Invalid;
        break;
    }

    return result;
}

} } // namespace adit { namespace carplay
